// Utility.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "windows.h"
#include "pemdll.h"
#include "conio.h"

void showpwr(CPEMDll* pem)
{
	int status;
	double dval = 0;

	status = pem->GETPWRSTS();
	if (status == 1) 
	{
		printf("Power On!\n");
	}
	else 
	{
		printf("Power Off!\n");
	}

	status = pem->GET3V3V(&dval);
	if (status == 0) 
	{
		printf("3.3V Voltage = %f\n", dval);
	}
	else if (status == CPEMDLL_ERROR_ADCNOTEXIST)
	{
		printf("ADC Not Exist!\n");
	}
	else
	{
		printf("GET3V3V fail!\n");
	}

	status = pem->GET3V3I(&dval);
	if (status == 0) 
	{
		printf("3.3V Current = %f\n", dval);
	}
	else if (status == CPEMDLL_ERROR_ADCNOTEXIST)
	{
		printf("ADC Not Exist!\n");
	}
	else
	{
		printf("GET3V3I fail!\n");
	}

	status = pem->GET1V5V(&dval);
	if (status == 0) 
	{
		printf("1.5V Voltage = %f\n", dval);
	}
	else if (status == CPEMDLL_ERROR_ADCNOTEXIST)
	{
		printf("ADC Not Exist!\n");
	}
	else
	{
		printf("GET1V5V fail!\n");
	}

	status = pem->GET1V5I(&dval);
	if (status == 0) 
	{
		printf("1.5V Current = %f\n", dval);
	}
	else if (status == CPEMDLL_ERROR_ADCNOTEXIST)
	{
		printf("ADC Not Exist!\n");
	}
	else
	{
		printf("GET1V5I fail!\n");
	}

}
int main(int argc, char* argv[])
{
	int status;
	int pemvalid[4];
	int currpemno;
	double dval = 0;
	CPEMDll pem;
	int pcidevcount = 0;

//*****************************************
	status = pem.INIT();
//*****************************************

	for (int i = 0; i < 4; i++)
	{
		pemvalid[i] = pem.VALIDPEM(i);
		if (pemvalid[i] == 1) currpemno = i;
		printf("PEM[%d] %s\n", i, (pemvalid[i]==1) ? "Exist":"Not Exist");
	}

	status = pem.SELPEM(currpemno);
	if (status != 0) printf("SELPEM Error!\n");

	status = pem.VALIDDEV();
	if (status == 1) 
	{
		printf("VALIDDEV Success!\n");
	}
	else 
	{
		printf("VALIDDEV Fail!  Need to Assign A New Device\n");
	}
	showpwr(&pem);

	printf("Press Any Key to Disbale Driver and Power Off!\n");
	getch();

	status = pem.WINDIS(200);
	if (status == 0) printf("Driver Disabled!\n");
	else printf("Driver Disabled Fail!\n");

	status = pem.POFF();
	if (status == 0) printf("Power Off!\n");
	else printf("Power Off Fail!\n");

	printf("Press Any Key to Enable Driver and Power On!\n");
	getch();

	pem.PON();
	if (status == 0) 
	{
		printf("Power On!\n");
		status = pem.WINEN(200);
		if (status == 0) printf("Driver Enabled!\n");
		else printf("Driver Enabled Fail!\n");
	}
	else 
	{
		printf("Power On Fail!\n");
		status = pem.CHKSHORT();
		if (status & CPEMDLL_ERROR_3V3AUXSHORT) printf("3.3VAux Short!\n");
		if (status & CPEMDLL_ERROR_3V3SHORT) printf("3.3V Short!\n");
		if (status & CPEMDLL_ERROR_1V5SHORT) printf("1.5V Short!\n");

	}
	showpwr(&pem);


	pem.EXIT();

	return 0;
}


